/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.craft;

import cloud.lemonslice.teastory.blockentity.WoodenBarrelBlockEntity;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import cloud.lemonslice.teastory.tag.TeaTags;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.registry.BlockEntityRegister;
import xueluoanping.teastory.registry.ItemRegister;

public class WoodenBarrelBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE;

    public WoodenBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            BlockEntity te = worldIn.m_7702_(pos);
            if (FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)player.m_21120_(handIn), (int)1)).isPresent()) {
                return te.getCapability(ForgeCapabilities.FLUID_HANDLER, hit.m_82434_()).map(fluidTank -> {
                    FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)fluidTank);
                    return InteractionResult.SUCCESS;
                }).orElse(InteractionResult.FAIL);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof WoodenBarrelBlockEntity) {
            int i = ((WoodenBarrelBlockEntity)te).getFluidAmount();
            float f = (float)pos.m_123342_() + 0.0625f + 0.875f * (float)i / 2000.0f;
            if (!worldIn.m_5776_()) {
                ItemStack item;
                if (entityIn.m_5825_()) {
                    if (((WoodenBarrelBlockEntity)te).getFluid().m_205067_(FluidTags.f_13131_) && i > 250 && (float)entityIn.m_146904_() <= f) {
                        entityIn.m_252836_();
                    }
                } else if (entityIn instanceof ItemEntity && ((WoodenBarrelBlockEntity)te).getFluid() == Fluids.f_76193_ && (item = ((ItemEntity)entityIn).m_32055_()).m_204117_(TeaTags.Items.CROPS_RICE)) {
                    ((ItemEntity)entityIn).m_32045_(new ItemStack((ItemLike)ItemRegister.WASHED_RICE.get(), item.m_41613_()));
                }
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityRegister.WOODEN_BARREL_TYPE.get()).m_155264_(blockPos, blockState);
    }

    static {
        VoxelShape outer = VoxelShapeHelper.createVoxelShape(1.0, 0.0, 1.0, 14.0, 16.0, 14.0);
        VoxelShape inner = VoxelShapeHelper.createVoxelShape(2.0, 1.0, 2.0, 12.0, 15.0, 12.0);
        SHAPE = Shapes.m_83113_((VoxelShape)outer, (VoxelShape)inner, (BooleanOp)BooleanOp.f_82687_);
    }
}

